
<?php
session_start();
require_once '../db_connect.php';

if (!isset($_SESSION['admin_logged_in'])) header("Location: index.php");

// Approve Logic (Just update status)
if (isset($_GET['approve'])) {
    $wid = $_GET['approve'];
    $conn->query("UPDATE withdrawals SET status='approved' WHERE id='$wid'");
    header("Location: withdrawals.php");
}

// Reject Logic (Refund Balance)
if (isset($_GET['reject'])) {
    $wid = $_GET['reject'];
    
    // উইথড্র ইনফো বের করা
    $qry = $conn->query("SELECT * FROM withdrawals WHERE id='$wid' AND status='pending'");
    if ($qry->num_rows > 0) {
        $data = $qry->fetch_assoc();
        $uid = $data['user_id'];
        $amount = $data['amount'];

        // টাকা ব্যাক দেওয়া (Refund)
        $conn->query("UPDATE users SET balance = balance + $amount WHERE id='$uid'");
        // স্ট্যাটাস রিজেক্ট করা
        $conn->query("UPDATE withdrawals SET status='rejected' WHERE id='$wid'");
        
        echo "<script>alert('Withdrawal Rejected & Refunded!'); window.location='withdrawals.php';</script>";
    }
}

$withdrawals = $conn->query("SELECT withdrawals.*, users.phone, users.u_id FROM withdrawals JOIN users ON withdrawals.user_id = users.id ORDER BY withdrawals.id DESC");
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>Manage Withdrawals</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="style.css">
    <style>
        /* সেম স্টাইল ডিপোজিট পেজের মতো */
        table { width: 100%; border-collapse: collapse; margin-top: 20px; background: #1E2129; }
        th, td { padding: 10px; text-align: left; border-bottom: 1px solid #333; color: #ddd; }
        th { background: #000; color: #F5C300; }
        .badge { padding: 3px 8px; border-radius: 4px; font-size: 11px; }
        .pending { background: #ff9800; color: #000; }
        .approved { background: #28a745; color: #fff; }
        .rejected { background: #dc3545; color: #fff; }
        .btn { padding: 5px 10px; border-radius: 3px; text-decoration: none; color: #fff; font-size: 12px; margin-right: 5px; }
        .btn-approve { background: #28a745; }
        .btn-reject { background: #dc3545; }
    </style>
</head>
<body>
    <div class="sidebar">
        <div class="logo">BOT CLUB ADMIN</div>
        <ul>
            <li><a href="dashboard.php"><i class="fas fa-tachometer-alt"></i> Dashboard</a></li>
            <li><a href="users.php"><i class="fas fa-users"></i> Users</a></li>
            <li><a href="deposits.php"><i class="fas fa-money-bill-wave"></i> Deposits</a></li>
            <li><a href="withdrawals.php" class="active"><i class="fas fa-hand-holding-usd"></i> Withdrawals</a></li>
        </ul>
    </div>

    <div class="main-content">
        <div class="header"><h2>Withdrawal Requests</h2></div>
        <table>
            <thead>
                <tr>
                    <th>User ID</th>
                    <th>Phone</th>
                    <th>Method</th>
                    <th>Account No</th>
                    <th>Amount</th>
                    <th>Status</th>
                    <th>Action</th>
                </tr>
            </thead>
            <tbody>
                <?php while($row = $withdrawals->fetch_assoc()): ?>
                <tr>
                    <td><?php echo $row['u_id']; ?></td>
                    <td><?php echo $row['phone']; ?></td>
                    <td><?php echo $row['method']; ?></td>
                    <td><?php echo $row['account_number']; ?></td>
                    <td style="color:#ff4d4d; font-weight:bold;">৳ <?php echo $row['amount']; ?></td>
                    <td><span class="badge <?php echo $row['status']; ?>"><?php echo ucfirst($row['status']); ?></span></td>
                    <td>
                        <?php if($row['status'] == 'pending'): ?>
                            <a href="withdrawals.php?approve=<?php echo $row['id']; ?>" class="btn btn-approve" onclick="return confirm('Confirm Payment Sent?')">Sent</a>
                            <a href="withdrawals.php?reject=<?php echo $row['id']; ?>" class="btn btn-reject" onclick="return confirm('Reject and Refund?')">Reject</a>
                        <?php else: ?>
                            --
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endwhile; ?>
            </tbody>
        </table>
    </div>
</body>
</html>
